<?php
require __DIR__ . '/vendor/autoload.php';
$app = require_once __DIR__ . '/bootstrap/app.php';
$kernel = $app->make(Illuminate\Contracts\Console\Kernel::class);
$kernel->bootstrap();

$users = App\Models\User::whereIn('id', [1, 2, 3, 4, 5, 6, 7])->get();
foreach ($users as $user) {
    echo "User: " . $user->name . " (ID: " . $user->id . ")\n";
    echo "Last Seen: " . ($user->last_seen_at ? $user->last_seen_at->format('Y-m-d H:i:s') : 'NULL') . "\n";
    echo "Is Online: " . ($user->isOnline() ? 'YES' : 'NO') . "\n";
    echo "--------------------------------\n";
}

// Force update user 1 (Super Admin usually) to be online for testing
$admin = App\Models\User::find(1);
if ($admin) {
    $admin->last_seen_at = now();
    $admin->save();
    echo "Updated User 1 last_seen_at to NOW.\n";
}
